/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.hud;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.objects.MouseButton;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.systems.setting.Setting;
import Krasnodar.rockstarnew.systems.setting.SettingsContainer;
import Krasnodar.rockstarnew.ui.components.popup.Popup;
import Krasnodar.rockstarnew.ui.hud.GridLine;
import Krasnodar.rockstarnew.ui.hud.impl.island.DynamicIsland;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.game.cursor.CursorType;
import Krasnodar.rockstarnew.utility.game.cursor.CursorUtility;
import Krasnodar.rockstarnew.utility.gui.GuiUtility;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import Krasnodar.rockstarnew.utility.interfaces.IScaledResolution;
import Krasnodar.rockstarnew.utility.render.RenderUtility;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public abstract class HudElement
implements SettingsContainer,
IMinecraft {
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected final Animation animation = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    protected final Animation visible = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    protected final Animation selecting = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    protected final Animation dragAnim = new Animation(300L, 0.0f, Easing.FIGMA_EASE_IN_OUT);
    private final Animation blurAnim = new Animation(300L, 0.0f, Easing.FIGMA_EASE_IN_OUT);
    private final Animation loadingAnim = new Animation(700L, 0.0f, Easing.SMOOTH_STEP);
    private final Animation widthAnim = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    private final Animation heightAnim = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    protected boolean showing;
    protected boolean select;
    private List<Setting> settings = new ArrayList<Setting>();
    private boolean dragging;
    private float dragX;
    private float dragY;
    private float startDragX;
    private float startDragY;
    protected final String name;
    protected final String icon;

    public HudElement(String name, String icon) {
        this.name = name;
        this.icon = icon;
    }

    public void render(UIContext context) {
        this.update(context);
        float anim = this.animation.getValue() * this.visible.getValue();
        if (anim != 0.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, anim));
            float scale = 0.5f + anim * 0.5f - 0.05f * this.selecting.getValue();
            RenderUtility.scale(context.method_51448(), this.x + this.width / 2.0f, this.y + this.height / 2.0f, scale);
            this.renderComponent(context);
            RenderUtility.end(context.method_51448());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected abstract void renderComponent(UIContext var1);

    public void update(UIContext context) {
        boolean isLeftSide;
        float oldWidth = this.widthAnim.getValue();
        this.widthAnim.update(this.width);
        float newWidth = this.widthAnim.getValue();
        float widthDelta = newWidth - oldWidth;
        boolean bl = isLeftSide = this.x + this.width / 2.0f < IScaledResolution.sr.getScaledWidth() / 2.0f;
        if (!isLeftSide) {
            this.x -= widthDelta;
        }
        if (widthDelta != 0.0f) {
            for (HudElement otherElement : Rockstar.getInstance().getHud().getElements()) {
                float distanceToOther;
                float verticalOverlap;
                if (otherElement == this || !otherElement.isShowing() || (verticalOverlap = Math.min(this.y + this.height, otherElement.y + otherElement.height) - Math.max(this.y, otherElement.y)) <= 0.0f) continue;
                if (isLeftSide) {
                    float rightEdge = this.x + newWidth;
                    distanceToOther = otherElement.x - rightEdge;
                    if (!(distanceToOther >= -5.0f) || !(distanceToOther <= 25.0f)) continue;
                    otherElement.x += widthDelta;
                    otherElement.x = Math.max(0.0f, Math.min(otherElement.x, IScaledResolution.sr.getScaledWidth() - otherElement.width));
                    continue;
                }
                float leftEdge = this.x;
                distanceToOther = leftEdge - (otherElement.x + otherElement.width);
                if (!(distanceToOther >= -5.0f) || !(distanceToOther <= 25.0f)) continue;
                otherElement.x -= widthDelta;
                otherElement.x = Math.max(0.0f, Math.min(otherElement.x, IScaledResolution.sr.getScaledWidth() - otherElement.width));
            }
        }
        this.width = newWidth;
        this.dragAnim.update(this.dragging);
        this.animation.setEasing(this.showing ? Easing.BAKEK : Easing.BAKEK_BACK);
        this.animation.update(this.showing);
        this.visible.setEasing(this.show() ? Easing.BAKEK : Easing.BAKEK_BACK);
        this.visible.update(this.show());
        this.selecting.update(this.select);
        this.blurAnim.update(this.animation.getValue() >= 0.6f);
        if (this.dragging) {
            this.x = Math.clamp((float)context.getMouseX() - this.dragX, 0.0f, IScaledResolution.sr.getScaledWidth() - this.width);
            this.y = Math.clamp((float)context.getMouseY() - this.dragY, 0.0f, IScaledResolution.sr.getScaledHeight() - this.height);
            if (!(this instanceof DynamicIsland)) {
                for (GridLine line : Rockstar.getInstance().getHud().getGrid().getLines()) {
                    if (line.getType() == GridLine.Type.VERTICAL) {
                        this.x = this.snapToLine(line, this.x, List.of(Float.valueOf(0.0f), Float.valueOf(this.width), Float.valueOf(this.width / 2.0f)), List.of(Float.valueOf(0.0f), Float.valueOf(-this.width), Float.valueOf(-this.width / 2.0f)));
                        continue;
                    }
                    this.y = this.snapToLine(line, this.y, List.of(Float.valueOf(0.0f), Float.valueOf(this.height)), List.of(Float.valueOf(0.0f), Float.valueOf(-this.height)));
                }
            }
        }
        if (this.isHovered(context) && this.animation.getValue() >= 1.0f) {
            CursorUtility.set(CursorType.HAND);
        }
    }

    public void onMouseClicked(double mouseX, double mouseY, MouseButton button) {
        if (this.isHovered(mouseX, mouseY) && this.showing) {
            if (button == MouseButton.LEFT) {
                this.dragging = true;
                this.dragX = (float)(mouseX - (double)this.x);
                this.dragY = (float)(mouseY - (double)this.y);
                this.startDragX = this.x;
                this.startDragY = this.y;
            } else if (button == MouseButton.RIGHT) {
                this.select = true;
                this.loadingAnim.setValue(0.0f);
                Popup popup = new Popup((float)mouseX, (float)mouseY, 110.0f, 6.0f).title(Localizator.translate(this.settings.isEmpty() ? "actions" : "settings")).separator();
                for (Setting setting : this.settings) {
                    popup.setting(setting);
                }
                popup.button(Localizator.translate("remove"), "icons/hud/trash.png", popup1 -> {
                    this.showing = false;
                    popup1.setShowing(false);
                    Rockstar.getInstance().getFileManager().writeFile("client");
                }).onClose(() -> {
                    this.select = false;
                });
                Rockstar.getInstance().getHud().getPopups().add(popup);
            }
        }
    }

    public void onMouseReleased(double mouseX, double mouseY, MouseButton button) {
        if (this.dragging && button == MouseButton.LEFT) {
            this.dragging = false;
            if (this.x != this.startDragX || this.y != this.startDragY) {
                Rockstar.getInstance().getHud().getHistoryManager().registerMove(this, this.startDragX, this.startDragY, this.x, this.y);
            }
            Rockstar.getInstance().getFileManager().writeFile("client");
        }
    }

    private float snapToLine(GridLine line, float pos, List<Float> offsets, List<Float> adjustments) {
        for (int i = 0; i < offsets.size(); ++i) {
            float distance = Math.abs(pos + offsets.get(i).floatValue() - line.getPos());
            if (distance < 25.0f) {
                line.setActive(true);
            }
            if (!(distance < 5.0f)) continue;
            pos = line.getPos() + adjustments.get(i).floatValue();
        }
        return pos;
    }

    public boolean show() {
        return true;
    }

    public boolean isHovered(float mouseX, float mouseY) {
        return GuiUtility.isHovered((double)this.x, (double)this.y, (double)this.width, (double)this.height, mouseX, mouseY);
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return GuiUtility.isHovered((double)this.x, (double)this.y, (double)this.width, (double)this.height, mouseX, mouseY);
    }

    public boolean isHovered(UIContext context) {
        return this.isHovered(context.getMouseX(), context.getMouseY());
    }

    public void pos(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Generated
    public float getX() {
        return this.x;
    }

    @Generated
    public float getY() {
        return this.y;
    }

    @Generated
    public float getWidth() {
        return this.width;
    }

    @Generated
    public float getHeight() {
        return this.height;
    }

    @Generated
    public Animation getAnimation() {
        return this.animation;
    }

    @Generated
    public Animation getVisible() {
        return this.visible;
    }

    @Generated
    public Animation getSelecting() {
        return this.selecting;
    }

    @Generated
    public Animation getDragAnim() {
        return this.dragAnim;
    }

    @Generated
    public Animation getBlurAnim() {
        return this.blurAnim;
    }

    @Generated
    public Animation getLoadingAnim() {
        return this.loadingAnim;
    }

    @Generated
    public Animation getWidthAnim() {
        return this.widthAnim;
    }

    @Generated
    public Animation getHeightAnim() {
        return this.heightAnim;
    }

    @Generated
    public boolean isShowing() {
        return this.showing;
    }

    @Generated
    public boolean isSelect() {
        return this.select;
    }

    @Override
    @Generated
    public List<Setting> getSettings() {
        return this.settings;
    }

    @Generated
    public boolean isDragging() {
        return this.dragging;
    }

    @Generated
    public float getDragX() {
        return this.dragX;
    }

    @Generated
    public float getDragY() {
        return this.dragY;
    }

    @Generated
    public float getStartDragX() {
        return this.startDragX;
    }

    @Generated
    public float getStartDragY() {
        return this.startDragY;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public void setX(float x) {
        this.x = x;
    }

    @Generated
    public void setY(float y) {
        this.y = y;
    }

    @Generated
    public void setWidth(float width) {
        this.width = width;
    }

    @Generated
    public void setHeight(float height) {
        this.height = height;
    }

    @Generated
    public void setShowing(boolean showing) {
        this.showing = showing;
    }

    @Generated
    public void setSelect(boolean select) {
        this.select = select;
    }

    @Generated
    public void setSettings(List<Setting> settings) {
        this.settings = settings;
    }

    @Generated
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Generated
    public void setDragX(float dragX) {
        this.dragX = dragX;
    }

    @Generated
    public void setDragY(float dragY) {
        this.dragY = dragY;
    }

    @Generated
    public void setStartDragX(float startDragX) {
        this.startDragX = startDragX;
    }

    @Generated
    public void setStartDragY(float startDragY) {
        this.startDragY = startDragY;
    }
}

